package cn.com.duiba.quanyi.center.api.dto.pkg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包推广渠道表
 *
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
public class GoodsPkgChannelDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品包主键
     */
    private Long goodsPkgId;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 数量
     */
    private Long totalNum;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 是否启用, 0-停用, 1-启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer channelStatus;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 渠道类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.VisitChannelTypeEnum
     */
    private Integer channelType;

    /**
     * 券类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.VisitCouponTypeEnum
     */
    private Integer couponType;

    /**
     * 背景图
     */
    private String backgroundImg;
}