package cn.com.duiba.quanyi.center.api.dto.goods;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 商品库下单结果
 *
 * @author lizhi
 * @date 2023/8/18 16:16
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class GoodsOrderResultDto implements Serializable {

    private static final long serialVersionUID = 2440785135308791075L;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 成功时有值
     */
    private String goodsOrderNo;

    /**
     * 订单状态, 成功时有值
     *
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum#getStatus()
     */
    private Integer orderStatus;

    /**
     * 是否成功
     *
     * @return
     */
    public boolean isSuccess() {
        return failCode == null || failCode.isEmpty();
    }
}
