package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeDto implements Serializable {

    private static final long serialVersionUID = 7513946728797932003L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图
     */
    private String prizeImg;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.goods.common.enums.goods.SpuType
     */
    private Integer spuType;

    /**
     * 面额，类型为微信立减金时，必填
     */
    private Long amount;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}