package cn.com.duiba.quanyi.center.api.dto.contract;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ContractGoodsDto implements Serializable {

    private static final long serialVersionUID = 6357525696907545012L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 结算
     */
    private String settlementRate;

    /**
     * 结算方式
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum
     */
    private Integer settlementMethod;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}