package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPageQueryParam;

import java.util.List;

/**
 * 活动表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    ActivityDto selectById(Long id);

    /**
     * 创建活动
     *
     * @param activityDto
     * @return id
     */
    Long insert(ActivityDto activityDto);

    /**
     * 更新活动
     *
     * @param activityDto
     * @return id
     */
    int update(ActivityDto activityDto);

    /**
     * 更新活动
     *
     * @param id     活动id
     * @param status 状态
     * @return 影响行数
     */
    int updateStatus(Long id, int status);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 分页查询
     *
     * @return 活动
     */
    List<ActivityDto> selectPage(ActivityPageQueryParam activityPageQueryParam);

    /**
     * count
     *
     * @return 数量
     */
    Integer count(Integer activityStatus);
}