package cn.com.duiba.quanyi.center.api.remoteservice.coupon;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponStockDto;

import java.util.Map;
import java.util.Set;

/**
 * 微信立减金库存表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteWxCouponStockService {
    /**
     * 根据微信立减金主键查询
     *
     * @param wxCouponId
     * @return
     */
    WxCouponStockDto selectByWxCouponId(Long wxCouponId);

    /**
     * 根据微信立减金主键批量查询
     *
     * @param list 主键
     * @return 微信立减金库存
     */
    Map<Long, WxCouponStockDto> selectByWxCouponIdList(Set<Long> list);
}