package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动退款记录
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ActivityOrderRefundDto implements Serializable {

    private static final long serialVersionUID = 3825538042080246699L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 实际退款金额大于0，单位为分
     */
    private Long refundAmount;

    /**
     * 退款单号
     */
    private String bizRefundNo;

    /**
     * 订单号
     */
    private String bizOrderNo;

    /**
     * 渠道返回的交易流水号
     */
    private String transactionNo;

    /**
     * 1 初始化 2 第三方收单失败 3 第三方收单成功 4 退款成功 5 退款失败
     * @see cn.com.duiba.paycenter.enums.RefundOrderStatusEnum
     */
    private Integer refundStatus;

    /**
     * 退款单号(商户退款单号)
     */
    private String outRefundNo;

    /**
     * 第三方退款流水号
     */
    private String refundNo;

    /**
     * 退款成功时间
     */
    private Date refundTime;

    /**
     * 退款失败后渠道方返回的错误码
     */
    private String failureCode;

    /**
     * 退款失败后渠道方返回的错误描述
     */
    private String failureMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}