package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信立减金表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class WxCouponDto implements Serializable {

    private static final long serialVersionUID = 7640068797616958881L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 批次创建时间
     */
    private Date createTime;

    /**
     * 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * 可用结束时间
     */
    private Date availableEndTime;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}