package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/8/19 12:22
 */
@Getter
@AllArgsConstructor
public enum ActivityOrderPayStatusEnum {

    INIT(0, "初始化状态"),
    ORDER_SUCCESS(1,"第三方支付收单成功"),
    ORDER_FAIL(2, "第三方支付收单失败"),
    PAY_FAIL(3, "支付失败"),
    PAY_SUCCESS(4, "支付成功"),
    PAY_REVERSED(5, "支付取消"),
    REFUNDING(6, "退款中"),
    REFUND_SUCCESS(7, "退款成功"),
    REFUND_FAIL(8, "退款失败")
    ;
    private final Integer code;
    private final String desc;
    
    private static final Map<Integer, ActivityOrderPayStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityOrderPayStatusEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static ActivityOrderPayStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
