package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/8/7 16:26
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeOrderStatusEnum {
    //订单状态, 1-处理中，2-成功，3-失败, 4-异常
    PROCESS(1, "处理中"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    EXCEPTION(4, "异常"),
    ;
    
    private final Integer status;
    
    private final String desc;
    
    private static final Map<Integer, ActivityPrizeOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityPrizeOrderStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static ActivityPrizeOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
