package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveRecordDto;

import java.util.List;

/**
 * 活动奖品领取记录
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveRecordService {

    /**
     * 根据活动和用户查询
     * @param activityId 活动
     * @param userId 用户
     * @return 领取记录列表
     */
    List<ActivityPrizeReceiveRecordDto> selectByActivityUser(Long activityId, Long userId);

    /**
     * 根据奖品、用户查询
     * @param activityPrizeId 奖品ID
     * @param userId 用户ID
     * @return 领取记录
     */
    ActivityPrizeReceiveRecordDto selectByActivityPrizeUser(Long activityPrizeId, Long userId);
}