package cn.com.duiba.quanyi.center.api.remoteservice.contract;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractDto;
import cn.com.duiba.quanyi.center.api.dto.partner.PartnerDto;

import java.util.Map;
import java.util.Set;

/**
 * 合同表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteContractService {
    /**
     * 查询合同所属的客户
     *
     * @param contractId
     * @return
     */
    PartnerDto findPartnerByContractId(Long contractId);

    /**
     * 查询合同所属的客户
     *
     * @param contractIdList
     * @return
     */
    Map<Long, PartnerDto> findPartnerByContractIdList(Set<Long> contractIdList);


    /**
     * 根据合同编号查询
     *
     * @param contractCode
     * @return
     */
    ContractDto findByContractCode(String contractCode);
}