/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.sm;

import cn.hutool.core.codec.Base62;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.UUID;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Util {
    private static final Logger log = LoggerFactory.getLogger(SM2Util.class);
    public static ThreadLocal<Signature> signature = ThreadLocal.withInitial(() -> {
        try {
            return Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "BC");
        }
        catch (Exception e) {
            log.error("genSignature", (Throwable)e);
            throw new RuntimeException(e);
        }
    });

    public static KeyPair createKeyPair() {
        X9ECParameters ecParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECNamedCurveParameterSpec sm2Spec = new ECNamedCurveParameterSpec(GMObjectIdentifiers.sm2p256v1.toString(), ecParameters.getCurve(), ecParameters.getG(), ecParameters.getN());
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EC", "BC");
            gen.initialize((AlgorithmParameterSpec)sm2Spec, new SecureRandom());
            KeyPair keyPair = gen.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            log.warn("createKeyPair fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String sign(PrivateKey privateKey, String plainText) {
        try {
            signature.get().initSign(privateKey);
            signature.get().update(plainText.getBytes());
            byte[] bytes = signature.get().sign();
            return Base62.encode((byte[])bytes);
        }
        catch (Exception e) {
            log.error("sign fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String sign(String privateKeyStr, String plainText) {
        try {
            byte[] privateBytes = Base62.decode((CharSequence)privateKeyStr);
            PrivateKey privateKey = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateBytes));
            return SM2Util.sign(privateKey, plainText);
        }
        catch (Exception e) {
            log.error("sign fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean verifySign(PublicKey publicKey, String sign, String plainText) {
        try {
            signature.get().initVerify(publicKey);
            signature.get().update(plainText.getBytes());
            return signature.get().verify(Base62.decode((CharSequence)sign));
        }
        catch (Exception e) {
            log.error("sign fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySign(String publicKeyStr, String sign, String plainText) {
        try {
            byte[] publicBytes = Base62.decode((CharSequence)publicKeyStr);
            PublicKey publicKey = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)SubjectPublicKeyInfo.getInstance((Object)publicBytes));
            return SM2Util.verifySign(publicKey, sign, plainText);
        }
        catch (Exception e) {
            log.error("verifySign fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        KeyPair keyPair = SM2Util.createKeyPair();
        byte[] pk = keyPair.getPrivate().getEncoded();
        String sm2PrivateKey = Base62.encode((byte[])pk);
        System.out.println("SM2\u79c1\u94a5:\uff08\u7b7e\u540d\u65b9\u8bf7\u81ea\u884c\u4fdd\u5b58\uff09");
        System.out.println(sm2PrivateKey);
        String sm2PublicKey = Base62.encode((byte[])keyPair.getPublic().getEncoded());
        System.out.println("SM2\u516c\u94a5:\uff08\u8bf7\u63d0\u4f9b\u7ed9\u9a8c\u7b7e\u65b9\uff09");
        System.out.println(sm2PublicKey);
        String intfKey = "123456";
        String reqId = UUID.randomUUID().toString();
        Long timestamp = System.currentTimeMillis();
        String bizData = "5IhFeKrq60gOM7N2crGnsQUTYpMgXjGG0YkJwwVrDociYMRiJA42MgKtvGorFJo2kBdsyFLnlxH96J7teEl6wuZ3ZrsfhkLqUwImdZql48qx";
        StringBuilder srcBuilder = new StringBuilder(intfKey);
        srcBuilder.append('_').append(reqId).append('_').append(timestamp).append('_').append(bizData);
        String src = srcBuilder.toString();
        System.out.println("\u7b7e\u540d\u524d\u6570\u636esrc\uff1a" + src);
        String sign = SM2Util.sign(sm2PrivateKey, src);
        System.out.println("\u7b7e\u540dsign\uff1a" + sign);
        boolean result = SM2Util.verifySign(sm2PublicKey, sign, src);
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + result);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

