package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * 奖品领取结果
 *
 * @author lizhi
 * @date 2023/8/18 16:16
 */
@Data
public class ActivityPrizeReceiveResultDto implements Serializable {

    private static final long serialVersionUID = 2440785135308791075L;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 商品订单，成功时有值
     */
    private String goodsOrderNo;

    /**
     * 商品订单状态，成功时有值
     *
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum#getStatus()
     */
    private Integer orderStatus;

    /**
     * 第几次领取
     */
    private Integer takeNum;

    /**
     * 是否成功
     *
     * @return
     */
    public boolean isSuccess() {
        return failCode == null || failCode.isEmpty();
    }
}
