package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/8/7 16:26
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderStatusEnum {
    //订单状态, 1-处理中，2-成功，3-失败, 4-异常
    /**
     * 发放页面展示：处理中
     * 领取页面展示：处理中
     */
    PROCESS(1, "处理中"),
    /**
     * 发放页面展示：领取成功
     * 领取页面展示：领取成功
     */
    SUCCESS(2, "成功"),
    /**
     * 明确的不能重试成功的错误，比如：用户领取次数超过上限等用户原因
     * 发放页面展示：领取失败
     * 领取页面展示：领取失败
     */
    FAIL(3, "失败，无法自动重试成功"),
    /**
     * 发放页面展示：领取中
     * 领取页面展示：领取中
     */
    EXCEPTION(4, "异常"),
    /**
     * 发放页面展示：待领取
     * 领取页面展示：待领取
     */
    NOT_RECEIVE(5, "待领取"),
    /**
     * 可重试的错误，比如：预算不足、熔断等
     * 发放页面展示：处理中
     * 领取页面展示：处理中
     */
    FAIL_CAN_RETRY(6, "失败，自动重试可能会成功"),
    /**
     * 发放页面展示：待领取
     * 领取页面展示：领取中
     */
    SHORT_URL_RECEIVE_PROCESS(7, "短链领取中"),
    /**
     * 发放页面展示：待领取
     * 领取页面展示：领取失败
     */
    SHORT_URL_RECEIVE_FAIL(8, "短链领取失败，无法自动重试成功"),
    /**
     * 发放页面展示：待领取
     * 领取页面展示：领取中
     */
    SHORT_URL_RECEIVE_FAIL_CAN_RETRY(9, "短链领取失败，自动重试可能会成功"),
    /**
     * 发放页面展示：待领取
     * 领取页面展示：领取中
     */
    SHORT_URL_RECEIVE_EXCEPTION(10, "短链领取异常"),
    ;
    
    private final Integer status;
    
    private final String desc;
    
    private static final Map<Integer, GoodsOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(GoodsOrderStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static GoodsOrderStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    private static final Set<Integer> FINAL_STATUS_SET = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(SUCCESS.getStatus(), FAIL.status)));


    public static boolean isFinalStatus(Integer status) {
        if (status == null) {
            return false;
        }
        return true;
    }
}
