package cn.com.duiba.quanyi.center.api.remoteservice.contract;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractDto;
import cn.com.duiba.quanyi.center.api.dto.partner.PartnerDto;
import cn.com.duiba.quanyi.center.api.param.ContractPageQueryParam;

import cn.com.duiba.quanyi.center.api.param.contract.QueryContractParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 合同表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteContractService {
    /**
     * 查询合同所属的客户
     *
     * @param contractId
     * @return
     */
    PartnerDto findPartnerByContractId(Long contractId);

    /**
     * 查询合同所属的客户
     *
     * @param contractIdList
     * @return
     */
    Map<Long, PartnerDto> findPartnerByContractIdList(Set<Long> contractIdList);


    /**
     * 根据合同编号查询
     *
     * @param contractCode
     * @return
     */
    ContractDto findByContractCode(String contractCode);

    /**
     * 分页查询
     *
     * @param contractPageQueryParam
     * @return
     */
    List<ContractDto> findPageByParam(ContractPageQueryParam contractPageQueryParam);

    /**
     * 统计
     *
     * @param contractPageQueryParam
     * @return
     */
    Integer countByParam(ContractPageQueryParam contractPageQueryParam);

    /**
     * 查询客户id下所有的合同
     *
     * @param partnerId
     * @return
     */
    List<ContractDto> findByPartnerId(Long partnerId);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Long insert(ContractDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    int update(ContractDto dto);

    /**
     * 根据id查询
     *
     * @param contractId
     * @return
     */
    ContractDto findById(Long contractId);

    /**
     * 根据id list查询
     *
     * @param list
     * @return
     */
    Map<Long, ContractDto> findByIdList(Set<Long> list);


    /**
     * 根据条件查询对应的合同信息
     * @param param 请求参数
     * @return 合同信息
     */
    List<ContractDto> findByParam(QueryContractParam param);
}