package cn.com.duiba.quanyi.center.api.dto.demand;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class DemandDto implements Serializable {

    private static final long serialVersionUID = 6308753929200449818L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 需求描述
     */
    private String demandDesc;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建人id
     */
    private Long createPersonId;

    /**
     * 创建人名称
     */
    private String createPersonName;
}