package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityStaffDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityStaffPageQueryParam;

import java.util.List;

/**
 * 活动员工信息表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityStaffService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动员工信息
     */
    ActivityStaffDto selectById(Long id);

    /**
     * 新增
     *
     * @param activityStaffDto 活动员工信息
     * @return 执行结果
     */
    Long insert(ActivityStaffDto activityStaffDto);

    /**
     * 更新
     *
     * @param activityStaffDto 活动员工信息
     * @return 执行结果
     */
    int update(ActivityStaffDto activityStaffDto);

    /**
     * 根据活动及手机号查询
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @return 活动员工信息
     */
    ActivityStaffDto selectByActivityPhone(Long activityId, String staffPhone);

    /**
     * 根据活动及用户查询
     *
     * @param activityId 活动id
     * @param userId     用户id
     * @return 活动员工信息
     */
    ActivityStaffDto selectByActivityUser(Long activityId, Long userId);

    /**
     * 根据用户ID查询
     *
     * @param userId 用户ID
     * @return 活动员工信息
     */
    List<ActivityStaffDto> selectByUserId(Long userId);

    /**
     * 根据活动id批量查询
     *
     * @param param
     * @return 活动员工信息
     */
    List<ActivityStaffDto> findPageByActivityId(ActivityStaffPageQueryParam param);

    /**
     * 根据活动id count
     *
     * @param activityId
     * @return count
     */
    Integer countByActivityId(Long activityId);


    /**
     * 绑定小B用户
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @param userId 绑定的用户id
     * @return 执行结果
     */
    int bindUser(Long activityId, String staffPhone, Long userId);

    /**
     * 解绑小B用户
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @return
     */
    int unbindUser(Long activityId, String staffPhone);


    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);
}