package cn.com.duiba.quanyi.center.api.remoteservice.coupon;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.BindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponSaveOrUpdateParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 微信立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteWxCouponService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 微信立减金
     */
    WxCouponDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param list 主键
     * @return 微信立减金
     */
    Map<Long, WxCouponDto> selectByIdList(Set<Long> list);

    /**
     * 根据需求ID查询
     *
     * @param demandId 需求ID
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectByDemandId(Long demandId);

    /**
     * 分页查询
     *
     * @param param 分页参数
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectPage(WxCouponPageParam param);

    /**
     * 总条数
     *
     * @param param 分页参数
     * @return 总条数
     */
    long selectCount(WxCouponPageParam param);

    /**
     * 新增或修改微信立减金
     *
     * @param param 新增或修改参数
     * @return 是否成功
     */
    boolean saveOrUpdate(WxCouponSaveOrUpdateParam param);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 绑定到需求商品
     *
     * @return
     */
    int bindDemandGoods(BindDemandGoodsParam param);

    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<BindDemandGoodsParam> list);

    /**
     * 批量解绑需求商品
     * @param ids 主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 解除绑定
     *
     * @return
     */
    int unbindDemandGoods(Long id, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId
     * @return
     */
    List<WxCouponDto> findByDemandGoodsId(Long demandGoodsId);
}