package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityStockDto;

import java.util.List;
import java.util.Map;

/**
 * 支付宝立减金库存
 *
 * @author zzy
 * @create 2023-09-22 20:23:15
 **/
@AdvancedFeignClient
public interface RemoteAlipayActivityStockService {
    /**
     * 根据支付宝立减金主键查询
     *
     * @param alipayActivityId 支付宝立减金ID
     * @return
     */
    AlipayActivityStockDto selectByAlipayActivityId(Long alipayActivityId);

    /**
     * 根据支付宝立减金主键批量查询
     *
     * @param alipayActivityIds 支付宝立减金ID集合
     * @return key：立减金ID，value：支付宝立减金库存
     */
    Map<Long, AlipayActivityStockDto> selectByAlipayActivityIdList(List<Long> alipayActivityIds);
}
