package cn.com.duiba.quanyi.center.api.dto.insurance.login;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司端-登录账户表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceLoginAccountDto implements Serializable {
     
    private static final long serialVersionUID = 17095322686863468L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 账号类型：1-超级管理员，2-管理员，3-坐席
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 姓名
     */
    private String accountName;

    /**
     * 是否启用，0-否，1-是
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer accountStatus;

    /**
     * 机构ID，仅坐席有值，tb_insurance_institution.id
     */
    private Long institutionId;
}