package cn.com.duiba.quanyi.center.api.log.operate;

import cn.com.duiba.quanyi.center.api.log.operate.bean.OperateLogBean;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
@EnableScheduling
@Import({OperateLogBean.class})
public class LogBasicConfiguration {
    @Bean
    public ExecutorService logExecutorService(){
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(500);
        return new ThreadPoolExecutor(10,40,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("sso"),
                new AbortPolicyWithReport());
    }
}
