package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动白名单表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ActivityWhiteListDto implements Serializable {

    private static final long serialVersionUID = 5787322164815993753L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 用户手机号
     */
    private String userPhone;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 上传任务id
     */
    private Long taskId;

    /**
     * 添加白名单的操作人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum
     */
    private Integer operatorType;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 添加人姓名
     */
    private String operatorName;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 删除白名单的操作人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum
     */
    private Integer deleteOperatorType;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 绑定用户时间
     */
    private Date bindTime;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}