package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;

/**
 * 优惠券表
 * @author mybatis generator 
 * @date 2023-11-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CcbLifeCouponSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17007078548296684L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 三方优惠券id
     */
    private String thirdCouponId;

    /**
     * 三方优惠券名称
     */
    private String thirdCouponName;

    /**
     * 费用来源
     */
    private String sourceExpenses;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Integer deleted;

    /**
     * 创建时间:开始
     */
    private Date gmtCreateBegin;

    /**
     * 创建时间：结束
     */
    private Date gmtCreateOver;


    /**
     * 更新时间：开始
     */
    private Date gmtModifiedBegin;

    /**
     * 更新时间：结束
     */
    private Date gmtModifiedOver;


    /**
     * 优惠券ID：以英文逗号进行分割
     */
    private List<String> couponIds;

    /**
     * 优惠券ID集合
     */
    private Set<String> thirdCouponIds;

    /**
     * 文件id集合
     */
    private List<Long> fileIds;

    /**
     * 文件id集合
     */
    private Long fileId;

    /**
     * 是否存在门店： 1、是； 2、否
     */
    private Integer existed;

}