package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceFundAccountDto;

import java.util.List;

/**
 * 保司资金账户表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceFundAccountService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司资金账户
     */
    InsuranceFundAccountDto selectById(Long id);

    /**
     * 根据手机号和公司id查询
     * @param companyId 公司id
     * @param accountPhone 手机号
     * @return
     */
    InsuranceFundAccountDto selectByCompanyPhone(Long companyId, String accountPhone);

    /**
     * 根据手机号查询
     * @param accountPhone 手机号
     * @return
     */
    List<InsuranceFundAccountDto> selectByPhone(String accountPhone);


}