package cn.com.duiba.quanyi.center.api.remoteservice.icbc.gd;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.gd.IcbcGdTakeRecordDto;

/**
 * 广东工行春节活动领取记录
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteIcbcGdTakeRecordService {

    /**
     * 根据活动和用户查询当天领取记录
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 广东工行春节活动领取记录
     */
    IcbcGdTakeRecordDto selectByActAndUser(Long activityId, Long userId);

    /**
     * 查询当日记录，不存在则新增
     * @param activityId 活动ID
     * @param userId 用户ID
     * @param prizeId 奖品ID
     * @return 广东工行春节活动领取记录
     */
    IcbcGdTakeRecordDto saveIfAbsent(Long activityId, Long userId, Long prizeId);
}