package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.activity.BankEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2023/8/21 14:35
 */
@Data
public class WxCouponSaveOrUpdateParam implements Serializable {
    
    private static final long serialVersionUID = 4054185207688365963L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 微信批次名称
     */
    private String stockName;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 总预算，单位分
     */
    private Long maxAmount;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 使用券金额门槛，单位分
     */
    private Long transactionMinimum;

    /**
     * 批次创建时间
     */
    private Date createTime;

    /**
     * 批次状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockStatusEnum#getStatus()
     */
    private String stockStatus;

    /**
     * 批次类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private Integer stockType;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * 可用结束时间
     */
    private Date availableEndTime;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 微信返回的已发券数量
     */
    private Long distributedCoupons;

    /**
     * 用户领券后有效期为多少天，用于告警
     */
    private Integer userValidityPeriod;

    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;



    /**
     * 银行名称类型（可为空）
     * @see BankEnum ;
     */
    private String bankName;

    /**
     * 银行卡片类型
     * @see cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
     */
    private String bankCardType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;

}
