package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2024/3/4 15:30
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class InsuranceAccountTypeSearchParam extends PageQuery {

    private static final long serialVersionUID = 4925487799864635965L;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 账号类型：1-超级管理员，2-管理员，3-坐席
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceAccountTypeEnum
     */
    private Integer accountType;


    /**
     * 机构ID，仅坐席有值，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 账号ID
     */
    private Long accountId;

}
