package cn.com.duiba.quanyi.center.api.remoteservice.insurance.company;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceCompanySearchParam;

import java.util.List;

/**
 * 保险公司
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceCompanyService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保险公司集合
     */
    List<InsuranceCompanyDto> selectPage(InsuranceCompanySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceCompanySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保险公司
     */
    InsuranceCompanyDto selectById(Long id);

    /**
     * 新增
     * @param dto 保险公司
     * @return 执行结果
     */
    Long insert(InsuranceCompanyDto dto);

    /**
     * 更新
     * @param dto 保险公司
     * @return 影响行数
     */
    int update(InsuranceCompanyDto dto);

    /**
     * 根据主键列表查询
     * @param ids 主键
     * @return 保险公司
     */
    List<InsuranceCompanyDto> selectByIds(List<Long> ids);
}