package cn.com.duiba.quanyi.center.api.remoteservice.insurance.institution;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyStatDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionFundDto;

import java.util.List;

/**
 * 保司机构资金表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceInstitutionFundService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司机构资金
     */
    InsuranceInstitutionFundDto selectById(Long id);



    /**
     * 根据机构ID查询
     * @param institutionId
     * @return 保司机构资金
     */
    InsuranceInstitutionFundDto selectByInstitutionId(Long institutionId);


    /**
     * 根据机构ID列表，查询统计数据
     * @param institutionIds
     * @return
     */
    List<InsuranceInstitutionFundDto> selectByInstitutionIds(List<Long> institutionIds);


    /**
     * 新增
     * @param dto 新增保司机构资金
     * @return 执行结果
     */
    int insert(InsuranceInstitutionFundDto dto);


    /**
     * 更新保司机构资金
     * @param dto 保司机构资金
     * @return 执行结果
     */
    int update(InsuranceInstitutionFundDto dto);
}