package cn.com.duiba.quanyi.center.api.remoteservice.insurance.login;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceAccountTypeDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceAccountTypeSearchParam;
import java.util.List;

/**
 * 账户角色表
 * @author kjj mybatis generator 
 * @date 2024-03-06
 */
@AdvancedFeignClient
public interface RemoteInsuranceAccountTypeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账户角色集合
     */
    List<InsuranceAccountTypeDto> selectPage(InsuranceAccountTypeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceAccountTypeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账户角色
     */
    InsuranceAccountTypeDto selectById(Long id);

    /**
     * 新增
     * @param dto 账户角色
     * @return 执行结果
     */
    int insert(InsuranceAccountTypeDto dto);

    /**
     * 更新
     * @param dto 账户角色
     * @return 影响行数
     */
    int update(InsuranceAccountTypeDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}