package cn.com.duiba.quanyi.center.api.remoteservice.insurance.take;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceActivityTakeSplitDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeThresholdDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeParam;

import java.util.List;

/**
 * 保司权益兑换
 * @author lizhi
 * @date 2024/3/6 10:24
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeService {

    /**
     * 商品阈值
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return 结果
     */
    InsuranceTakeBaseResultDto<InsuranceTakeThresholdDto> threshold(Integer spuType);

    /**
     * 拆分
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param companyId 公司ID
     * @param amount 金额
     * @return 拆分结果
     */
    InsuranceTakeBaseResultDto<List<InsuranceActivityTakeSplitDto>> split(Integer spuType, Long companyId, Long amount);

    /**
     * 兑换
     * @param param 兑换参数
     * @return 是否提交成功
     */
    InsuranceTakeBaseResultDto<Void> take(InsuranceTakeParam param);
}
