package cn.com.duiba.quanyi.center.api.utils.insurance;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

/**
 * @author lizhi
 * @date 2024/3/7 14:56
 */
public class InsuranceGrantUtil {
    
    private InsuranceGrantUtil() {}

    private static final int GRANT_MINUTES = 2880;

    /**
     * 是否已到第二批次发放时间
     * @param createDate 创建日期
     * @param now 当前日期
     * @param minutes 多少分钟后发放
     * @return true-已到发放时间，false-未到
     */
    public static boolean afterGrantTime(Date createDate, Date now, int minutes) {
        Date grantDate = DateUtils.minutesAddOrSub(createDate, minutes);
        return now.after(grantDate);
    }
    
}
