package cn.com.duiba.quanyi.center.api.remoteservice.insurance.login;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceAccountTypeDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceAccountTypeSearchParam;

import java.util.List;

/**
 * 账户角色表
 * @author kjj mybatis generator 
 * @date 2024-03-06
 */
@AdvancedFeignClient
public interface RemoteInsuranceAccountTypeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账户角色集合
     */
    List<InsuranceAccountTypeDto> selectPage(InsuranceAccountTypeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceAccountTypeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账户角色
     */
    InsuranceAccountTypeDto selectById(Long id);

    /**
     * 根据唯一索引查询
     * @param accountId 账号ID
     * @param accountType 账号类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceAccountTypeEnum
     * @param companyId 公司ID
     * @return 账户角色
     */
    InsuranceAccountTypeDto selectByUk(Long accountId, Integer accountType, Long companyId);

    /**
     * 新增
     * @param dto 账户角色
     * @return 执行结果
     */
    int insert(InsuranceAccountTypeDto dto);

    /**
     * 更新
     * @param dto 账户角色
     * @return 影响行数
     */
    int update(InsuranceAccountTypeDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);



    /**
     * 根据公司ID列表与账号类型，查询保司端-账户角色表
     * @param companyIds
     * @param accountType
     * @return
     */
    List<InsuranceAccountTypeDto> selectByCompanyIdsAndAccountType(List<Long> companyIds, Integer accountType);



    /**
     * 根据机构ID列表与账号类型，查询保司端-账户角色表
     * @param institutionIds
     * @param accountType
     * @return
     */
    List<InsuranceAccountTypeDto> selectByInstitutionIdsAndAccountType(List<Long> institutionIds, Integer accountType);


    /**
     * 根据条件查询,查询所有登录集合
     * @param param 查询条件
     * @return 保司端-登录账户集合
     */
    List<InsuranceAccountTypeDto> selectListNoPage(InsuranceAccountTypeSearchParam param);


    /**
     * 根据公司、账号、角色查询
     * @param companyId 公司ID
     * @param accountIds 账号id集合
     * @param accountType 角色类型
     * @return
     */
    List<InsuranceAccountTypeDto> selectByCompanyAccountIds(Long companyId, List<Long> accountIds, Integer accountType);

}