package cn.com.duiba.quanyi.center.api.utils.insurance;

import java.text.DecimalFormat;

/**
 * @author lizhi
 * @date 2024/3/7 14:56
 */
public class InsuranceRateUtil {
    
    private InsuranceRateUtil() {}

    private static final DecimalFormat FORMAT = new DecimalFormat("#.00");
    
    public static String calculateRatesToString(long policyAmount, long equityAmount, String taxRate) {
        Double result = calculateRates(policyAmount, equityAmount, taxRate);
        return FORMAT.format(result);
    }

    /**
     * 计算费率
     * @param policyAmount 保费
     * @param equityAmount 权益费
     * @param taxRate 税率
     * @return 费率
     */
    public static double calculateRates(long policyAmount, long equityAmount, String taxRate) {
        return (equityAmount * parseRate(taxRate)) / policyAmount;
    }
    
    private static double parseRate(String rate) {
        return Double.parseDouble(rate);
    }
}
