package cn.com.duiba.quanyi.center.api.remoteservice.bill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bill.BillPushStockDto;
import cn.com.duiba.quanyi.center.api.param.bill.BillPushStockSearchParam;
import java.util.List;

/**
 * 账单推送数据-批次维度
 * @author kjj mybatis generator 
 * @date 2024-03-08
 */
@AdvancedFeignClient
public interface RemoteBillPushStockService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账单推送数据-批次维度集合
     */
    List<BillPushStockDto> selectPage(BillPushStockSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BillPushStockSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账单推送数据-批次维度
     */
    BillPushStockDto selectById(Long id);

    /**
     * 新增
     * @param dto 账单推送数据-批次维度
     * @return 执行结果
     */
    int insert(BillPushStockDto dto);

    /**
     * 更新
     * @param dto 账单推送数据-批次维度
     * @return 影响行数
     */
    int update(BillPushStockDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}