package cn.com.duiba.quanyi.center.api.remoteservice.ccb.sichuan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccb.sichuan.CcbSiChuanHuiMeiDto;
import cn.com.duiba.quanyi.center.api.param.ccb.sichuan.CcbSiChuanHuiMeiSearchParam;
import java.util.List;

/**
 * 建行四川惠美
 * @author kjj mybatis generator 
 * @date 2024-04-03
 */
@AdvancedFeignClient
public interface RemoteCcbSiChuanHuiMeiService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 建行四川惠美集合
     */
    List<CcbSiChuanHuiMeiDto> selectPage(CcbSiChuanHuiMeiSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbSiChuanHuiMeiSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 建行四川惠美
     */
    CcbSiChuanHuiMeiDto selectById(Long id);

    /**
     * 根据开发者ID查询
     * @param developerOrderId
     * @return
     */
    CcbSiChuanHuiMeiDto selectByDeveloperOrderId(String developerOrderId);

    /**
     * 根据goodsOrderNo 查询数据
     * @param goodsOrderNo
     * @return
     */
    CcbSiChuanHuiMeiDto selectByGoodsOrderNo(String  goodsOrderNo);

    /**
     * 新增
     * @param dto 建行四川惠美
     * @return 执行结果
     */
    int insert(CcbSiChuanHuiMeiDto dto);

    /**
     * 更新
     * @param dto 建行四川惠美
     * @return 影响行数
     */
    int update(CcbSiChuanHuiMeiDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}