package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtAliPayDto;
import cn.com.duiba.quanyi.center.api.param.user.UserExtAliPaySearchParam;
import java.util.List;

/**
 * 支付宝ext
 * @author kjj mybatis generator 
 * @date 2024-04-08
 */
@AdvancedFeignClient
public interface RemoteUserExtAliPayService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝ext集合
     */
    List<UserExtAliPayDto> selectPage(UserExtAliPaySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UserExtAliPaySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝ext
     */
    UserExtAliPayDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝ext
     * @return 执行结果
     */
    int insert(UserExtAliPayDto dto);

    /**
     * 更新
     * @param dto 支付宝ext
     * @return 影响行数
     */
    int update(UserExtAliPayDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 新增或保存
     * @param entity 关联信息
     * @return 执行结果
     */
    int saveOrUpdate(UserExtAliPayDto entity);


    /**
     * 通过alipayUserId 查询用户信息
     * @param alipayUserId
     * @return
     */
    UserExtAliPayDto selectByAlipayUserId( String alipayUserId);

    /**
     * 通过用户ID 查询 支付宝ext
     * @param userId
     * @return
     */
    UserExtAliPayDto selectByUserId( Long userId);


}