package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品领取记录
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeReceiveRecordDto implements Serializable {

    private static final long serialVersionUID = 1983166690426515826L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动奖品id
     */
    private Long activityPrizeId;

    /**
     * 第几次领取
     */
    private Integer takeNum;

    /**
     * 商品类型-批量领取时有值
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 发放方式-批量领取时有值
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 领取方式：1-单一领取，2-一键领取
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;

    /**
     * 批量领取订单号
     */
    private String batchOrderNo;

    /**
     * 批量领取短链关联的code
     */
    private String batchRefCode;

    /**
     * 批量领取短链URL
     */
    private String batchShortUrl;

    /**
     * 短链失效时间
     */
    private Date shortUrlExpireTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}