package cn.com.duiba.quanyi.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 微信立减金自动创建批次任务表
 * @author mybatis generator 
 * @date 2024-03-25
 */
@Data
public class WxCouponAutoCreateTaskDto implements Serializable {
     
    private static final long serialVersionUID = 17113344196237619L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 上传任务id tb_upload_task.id
     */
    private Long uploadTaskId;

    /**
     * 微信批次号 创建成功后回填
     */
    private String stockId;

    /**
     * 创建批次的商户号
     */
    private String mchId;

    /**
     * 批次类型 2-银行立减金
     */
    private Integer stockType;

    /**
     * 活动名称
     */
    private String stockName;

    /**
     * 活动预算 分
     */
    private Long budgetAmount;

    /**
     * 创建批次参数 json字符串存储
     * {@link WxCouponAutoCreateExtInfoDto}
     */
    private String extInfo;

    /**
     * 创建批次任务状态 0-初始化 1-创建中 2-创建成功 3-创建失败
     */
    private Integer taskStatus;

    /**
     * 错误描述
     */
    private String errorMsg;

    /**
     * 创建人Id,ssoId
     */
    private Long creatorId;

    /**
     * 创建人名称,ssoName
     */
    private String creatorName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}