package cn.com.duiba.quanyi.center.api.enums.ccblife;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;


import java.util.stream.Collectors;

/**
 * @author xjl
 * @date 2023/11/23 18:11
 */
@Getter
@AllArgsConstructor
public enum CostSourceTypeEnum {

    /**
     *
     */
    STORE("1", "商户"),
    ORGAN("2","机构"),
    GOV("3", "政府"),

    ;
    /**
     * 类型
     */
    private final String key;

    /**
     * 来源
     */
    private final String sourceType;

    private static final Map<String, CostSourceTypeEnum> map = new HashMap<>();

    public static Map<String, CostSourceTypeEnum> enumMapWithKey() {
        CostSourceTypeEnum[] values = CostSourceTypeEnum.values();
        for (CostSourceTypeEnum value : values) {
            map.put(value.getKey(), value);
        }
        return map;
    }

    public static Map<String, CostSourceTypeEnum> enumMapWithValue() {
        CostSourceTypeEnum[] values = CostSourceTypeEnum.values();
        for (CostSourceTypeEnum value : values) {
            map.put(value.getSourceType(), value);
        }
        return map;
    }

    public static List<String> getEnumValueByKeys(String[] keys) {
        if (Objects.isNull(keys)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = Lists.newArrayList();
        Map<String, CostSourceTypeEnum> map = enumMapWithKey();
        for (String key : keys) {
            CostSourceTypeEnum typeEnum = map.get(key);
            if (Objects.nonNull(typeEnum)) {
                list.add(typeEnum.getSourceType());
            }
        }
        return list;
    }

    public static List<String> getEnumKeyByValues(String[] values) {
        if (Objects.isNull(values)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = Lists.newArrayList();
        Map<String, CostSourceTypeEnum> map = enumMapWithValue();
        for (String value : values) {
            CostSourceTypeEnum typeEnum = map.get(value);
            if (Objects.nonNull(typeEnum)) {
                list.add(typeEnum.getKey());
            }
        }
        return list;
    }

    // 根据 key 获取对应的 value
    public static String getValueByKey(String key) {
        for (CostSourceTypeEnum e : CostSourceTypeEnum.values()) {
            if (e.getKey().equals(key)) {
                return e.getSourceType();
            }
        }
        return null;
    }


    // 根据数组中的元素获取对应的 values，以逗号分隔返回结果
    public static String getValuesByArray(String[] keys) {
        return Arrays.stream(keys)
                .map(CostSourceTypeEnum::getValueByKey)
                .filter(Objects::nonNull)
                .collect(Collectors.joining(","));
    }

    // 根据数组中的元素获取对应的 keys，以逗号分隔返回结果
    public static String getKeysByArray(String[] values) {
        return Arrays.stream(values)
                .map(CostSourceTypeEnum::getKeyByValue)
                .filter(Objects::nonNull)
                .collect(Collectors.joining(","));
    }

    // 根据 value 获取对应的 key
    public static String getKeyByValue(String value) {
        for (CostSourceTypeEnum e : CostSourceTypeEnum.values()) {
            if (e.getSourceType().equals(value)) {
                return e.getKey();
            }
        }
        return null;  // 或者抛出异常，表示未找到对应的枚举项
    }

}
