package cn.com.duiba.quanyi.center.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author xuzhigang
 * @date 2024/3/25 17:31
 **/
public class PriceUtils {
    /**
     * 将分转换为元 保留2位
     * @param price 分
     * @return 元
     */
    public static String convertF2Y(long price) {
        return BigDecimal.valueOf(price).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).toString();
    }

    /**
     * 将元转换为分
     * @param price 元
     * @return 分
     */
    public static Long convertY2F(String price) {
        return new BigDecimal(price).multiply(new BigDecimal(100)).longValue();
    }

    public static void main(String[] args) {
        System.out.println(convertY2F("100"));
    }
}
