package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 上传任务业务类型
 * @author lizhi
 * @date 2023/3/29 2:13 PM
 */
@Getter
@AllArgsConstructor
public enum UploadBizTypeEnum {
    ACTIVITY_WHITE_LIST_ADD(1, "上传活动白名单"),
    ACTIVITY_STAFF_ADD(2, "上传活动客户经理"),
    ACTIVITY_PRIZE_USER_CONF_ADD(3, "上传活动奖项白名单"),
    CARD_SECRET_COUPON_CODE_ADD(4, "上传卡劵-劵码"),
    CARD_SECRET_COUPON_LINK_CODE_ADD(5, "上传卡劵-链接劵"),
    CARD_SECRET_COUPON_ACCOUNT_ADD(6, "上传卡劵-账号密码"),
    ICBC_SX_WRITE_OFF_ADD(7, "山西工行核销导入"),
    CCB_BUSINESS_IMPORT(8, "建行商户导入"),
    CCB_LN_SETTLEMENT_IMPORT(9, "辽宁建行结算明细导入"),
    INSURANCE_AGENT_IMPORT(10, "保司坐席导入"),
    INSURANCE_EQUITY_IMPORT(11, "保司车险权益导入"),
    INSURANCE_EQUITY_VERITY_IMPORT(12, "保单验真导入"),
    INSURANCE_EQUITY_HISTORY_IMPORT(13, "保单权益历史数据迁移导入"),
    ICBC_STORE_IMPORT(14, "工行门店导入"),
    COUPON_BANK_UPLOAD(15, "自动创建批次-银行立减金"),
    INSURANCE_RENBAO_EQUITY_IMPORT(16, "人保保司车险权益导入"),
    FULL_COUPON_UPLOAD(17, "自动创建微信立减金-全场代金券"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
