package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动支付记录
 * @author kjj mybatis generator 
 * @date 2023-08-08
 */
@Data
public class ActivityPayRecordDto implements Serializable {

    private static final long serialVersionUID = -7469490083824349123L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 完成支付的订单号
     */
    private String bizOrderNo;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 活动重要信息快照
     */
    private String activitySnapshot;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}