package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 账单统计表-消耗商户维度
 * @author mybatis generator 
 * @date 2024-03-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillStatisticConsumeMchSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1709795567463372L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单id tb_bill.id
     */
    private Long billId;

    /**
     * 统计日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 消耗商户
     */
    private String consumeMchId;

    /**
     * 核销金额
     */
    private Long writeOffAmount;

    /**
     * 核销笔数
     */
    private Integer writeOffNum;

    /**
     * 退款核销金额 分
     */
    private Long refundWriteOffAmount;

    /**
     * 退款核销笔数
     */
    private Integer refundWriteOffNum;

    /**
     * 交易金额 分
     */
    private Long tradeAmount;

    /**
     * 交易笔数
     */
    private Integer tradeNum;

    /**
     * 退款交易金额 分
     */
    private Long refundTradeAmount;

    /**
     * 退款交易笔数
     */
    private Integer refundTradeNum;

    /**
     * 实际交易金额 分
     */
    private Long realTradeAmount;

    /**
     * 实际交易笔数
     */
    private Integer realTradeNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}