package cn.com.duiba.quanyi.center.api.enums.insurance;

import cn.com.duiba.quanyi.center.api.enums.coupon.VerifyNotifySceneTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:06
 */
@Getter
@AllArgsConstructor
public enum InsuranceAccountTypeEnum {
    SUPER_ADMIN(1, "超级管理员", 1),
    ADMIN(2, "公司管理员", 2),
    SALESMAN(3, "坐席", 4),

    AUDITOR(4, "审核人员", 4),

    VERIFY(5, "验真人员", 4),

    INSTITUTION(6, "机构管理员", 3),

    ;
    
    private final Integer type;
    
    private final String desc;

    private final Integer level;

    private static final Map<Integer, InsuranceAccountTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceAccountTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceAccountTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
