package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.CcbPayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxNativeCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 活动支付创建订单参数
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class InsurancePayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 退款业务ID
     */
    private Long refundId;


    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 支付渠道
     * @see PayChannelTypeEnum
     */
    private String payChannelType = PayChannelTypeEnum.WX_NATIVE.getChannelType();

    /**
     * 微信小程序支付参数
     */
    private WxNativeCreateOrderParam wxNative;


    /**
     * 用户openId
     */
    @Deprecated
    private String openId;

    /**
     * 用户ip
     */
    @Deprecated
    private String userIp;
}
