package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 退保追回
 * @author mybatis generator 
 * @date 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceRefundPayRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17127316399818847L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 完成支付的订单号
     */
    private String bizOrderNo;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 退款用户ID,tb_insurance_login_account
     */
    private Byte userId;

    /**
     * 客户手机号
     */
    private String customerPhone;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 保险费，单位分
     */
    private Long policyAmount;

    /**
     * 权益费，单位分
     */
    private Long equityAmount;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 机构ID
     */
    private Long institutionId;


    /**
     * 发放人
     */
    private String salesmanName;


    /**
     * 发放状态
     */
    private Integer paidStatus;


    /**
     * 排序类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquitySortTypeEnum
     */
    private Integer sortType;

    /**
     * 用户导出，记录偏移量ID
     */
    private Long lastId;

    /**
     * 代领人
     */
    private String takeProxyName;
}