package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceTakeRecordDto;

import java.util.Date;
import java.util.List;

/**
 * 保司兑换记录表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeRecordService {

    /**
     * 当日已领取金额
     * @param accountPhone 手机号
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return 金额
     */
    long sumDayAmount(String accountPhone, Integer spuType, Date now);

    /**
     * 当月已领取金额
     * @param accountPhone 手机号
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return 金额
     */
    long sumMonthAmount(String accountPhone, Integer spuType, Date now);

    /**
     * 分页查询兑换记录
     * @param lastId 上一页id，第一页不传
     * @param pageSize 分页大小
     * @param companyId 公司id
     * @param spuType 商品类型
     * @param userId 用户id
     * @return
     */
    List<InsuranceTakeRecordDto> selectByOffset(Long lastId, Integer pageSize, Long companyId, Integer spuType, Long userId);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    InsuranceTakeRecordDto selectById(Long id);


    /**
     * 根据takeOrderNo查询
     * @param takeOrderNo
     * @return
     */
    InsuranceTakeRecordDto selectByTakeOrderNo(String takeOrderNo);

}