package cn.com.duiba.quanyi.center.api.remoteservice.insurance.pay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.pay.InsuranceRefundPayRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceRefundPayRecordSearchParam;
import java.util.List;

/**
 * 退保追回
 * @author kjj mybatis generator 
 * @date 2024-04-10
 */
@AdvancedFeignClient
public interface RemoteInsuranceRefundPayRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 退保追回集合
     */
    List<InsuranceRefundPayRecordDto> selectPage(InsuranceRefundPayRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceRefundPayRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 退保追回
     */
    InsuranceRefundPayRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 退保追回
     * @return 执行结果
     */
    long insert(InsuranceRefundPayRecordDto dto);

    /**
     * 更新
     * @param dto 退保追回
     * @return 影响行数
     */
    int update(InsuranceRefundPayRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}